<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\APIhub;

class GoogleCloudApihubV1VersionMetadata extends \Google\Collection
{
  protected $collection_key = 'specs';
  protected $deploymentsType = GoogleCloudApihubV1DeploymentMetadata::class;
  protected $deploymentsDataType = 'array';
  /**
   * Optional. Timestamp indicating when the version was created at the source.
   *
   * @var string
   */
  public $originalCreateTime;
  /**
   * Optional. The unique identifier of the version in the system where it was
   * originally created.
   *
   * @var string
   */
  public $originalId;
  /**
   * Required. Timestamp indicating when the version was last updated at the
   * source.
   *
   * @var string
   */
  public $originalUpdateTime;
  protected $specsType = GoogleCloudApihubV1SpecMetadata::class;
  protected $specsDataType = 'array';
  protected $versionType = GoogleCloudApihubV1Version::class;
  protected $versionDataType = '';

  /**
   * Optional. The deployments linked to this API version. Note: A particular
   * API version could be deployed to multiple deployments (for dev deployment,
   * UAT deployment, etc.)
   *
   * @param GoogleCloudApihubV1DeploymentMetadata[] $deployments
   */
  public function setDeployments($deployments)
  {
    $this->deployments = $deployments;
  }
  /**
   * @return GoogleCloudApihubV1DeploymentMetadata[]
   */
  public function getDeployments()
  {
    return $this->deployments;
  }
  /**
   * Optional. Timestamp indicating when the version was created at the source.
   *
   * @param string $originalCreateTime
   */
  public function setOriginalCreateTime($originalCreateTime)
  {
    $this->originalCreateTime = $originalCreateTime;
  }
  /**
   * @return string
   */
  public function getOriginalCreateTime()
  {
    return $this->originalCreateTime;
  }
  /**
   * Optional. The unique identifier of the version in the system where it was
   * originally created.
   *
   * @param string $originalId
   */
  public function setOriginalId($originalId)
  {
    $this->originalId = $originalId;
  }
  /**
   * @return string
   */
  public function getOriginalId()
  {
    return $this->originalId;
  }
  /**
   * Required. Timestamp indicating when the version was last updated at the
   * source.
   *
   * @param string $originalUpdateTime
   */
  public function setOriginalUpdateTime($originalUpdateTime)
  {
    $this->originalUpdateTime = $originalUpdateTime;
  }
  /**
   * @return string
   */
  public function getOriginalUpdateTime()
  {
    return $this->originalUpdateTime;
  }
  /**
   * Optional. The specs associated with this version. Note that an API version
   * can be associated with multiple specs.
   *
   * @param GoogleCloudApihubV1SpecMetadata[] $specs
   */
  public function setSpecs($specs)
  {
    $this->specs = $specs;
  }
  /**
   * @return GoogleCloudApihubV1SpecMetadata[]
   */
  public function getSpecs()
  {
    return $this->specs;
  }
  /**
   * Required. Represents a version of the API resource in API hub. The ID of
   * the version will be generated by Hub.
   *
   * @param GoogleCloudApihubV1Version $version
   */
  public function setVersion(GoogleCloudApihubV1Version $version)
  {
    $this->version = $version;
  }
  /**
   * @return GoogleCloudApihubV1Version
   */
  public function getVersion()
  {
    return $this->version;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApihubV1VersionMetadata::class, 'Google_Service_APIhub_GoogleCloudApihubV1VersionMetadata');
