<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Aiplatform;

class GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis extends \Google\Model
{
  /**
   * Should not be used.
   */
  public const ANOMALY_DETECTION_BASELINE_BASELINE_UNSPECIFIED = 'BASELINE_UNSPECIFIED';
  /**
   * Choose the later one statistics generated by either most recent snapshot
   * analysis or previous import features analysis. If non of them exists, skip
   * anomaly detection and only generate a statistics.
   */
  public const ANOMALY_DETECTION_BASELINE_LATEST_STATS = 'LATEST_STATS';
  /**
   * Use the statistics generated by the most recent snapshot analysis if
   * exists.
   */
  public const ANOMALY_DETECTION_BASELINE_MOST_RECENT_SNAPSHOT_STATS = 'MOST_RECENT_SNAPSHOT_STATS';
  /**
   * Use the statistics generated by the previous import features analysis if
   * exists.
   */
  public const ANOMALY_DETECTION_BASELINE_PREVIOUS_IMPORT_FEATURES_STATS = 'PREVIOUS_IMPORT_FEATURES_STATS';
  /**
   * Should not be used.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The default behavior of whether to enable the monitoring. EntityType-level
   * config: disabled. Feature-level config: inherited from the configuration of
   * EntityType this Feature belongs to.
   */
  public const STATE_DEFAULT = 'DEFAULT';
  /**
   * Explicitly enables import features analysis. EntityType-level config: by
   * default enables import features analysis for all Features under it.
   * Feature-level config: enables import features analysis regardless of the
   * EntityType-level config.
   */
  public const STATE_ENABLED = 'ENABLED';
  /**
   * Explicitly disables import features analysis. EntityType-level config: by
   * default disables import features analysis for all Features under it.
   * Feature-level config: disables import features analysis regardless of the
   * EntityType-level config.
   */
  public const STATE_DISABLED = 'DISABLED';
  /**
   * The baseline used to do anomaly detection for the statistics generated by
   * import features analysis.
   *
   * @var string
   */
  public $anomalyDetectionBaseline;
  /**
   * Whether to enable / disable / inherite default hebavior for import features
   * analysis.
   *
   * @var string
   */
  public $state;

  /**
   * The baseline used to do anomaly detection for the statistics generated by
   * import features analysis.
   *
   * Accepted values: BASELINE_UNSPECIFIED, LATEST_STATS,
   * MOST_RECENT_SNAPSHOT_STATS, PREVIOUS_IMPORT_FEATURES_STATS
   *
   * @param self::ANOMALY_DETECTION_BASELINE_* $anomalyDetectionBaseline
   */
  public function setAnomalyDetectionBaseline($anomalyDetectionBaseline)
  {
    $this->anomalyDetectionBaseline = $anomalyDetectionBaseline;
  }
  /**
   * @return self::ANOMALY_DETECTION_BASELINE_*
   */
  public function getAnomalyDetectionBaseline()
  {
    return $this->anomalyDetectionBaseline;
  }
  /**
   * Whether to enable / disable / inherite default hebavior for import features
   * analysis.
   *
   * Accepted values: STATE_UNSPECIFIED, DEFAULT, ENABLED, DISABLED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis::class, 'Google_Service_Aiplatform_GoogleCloudAiplatformV1FeaturestoreMonitoringConfigImportFeaturesAnalysis');
