<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Bigquery;

class TableSchema extends \Google\Collection
{
  protected $collection_key = 'fields';
  protected $fieldsType = TableFieldSchema::class;
  protected $fieldsDataType = 'array';
  protected $foreignTypeInfoType = ForeignTypeInfo::class;
  protected $foreignTypeInfoDataType = '';

  /**
   * Describes the fields in a table.
   *
   * @param TableFieldSchema[] $fields
   */
  public function setFields($fields)
  {
    $this->fields = $fields;
  }
  /**
   * @return TableFieldSchema[]
   */
  public function getFields()
  {
    return $this->fields;
  }
  /**
   * Optional. Specifies metadata of the foreign data type definition in field
   * schema (TableFieldSchema.foreign_type_definition).
   *
   * @param ForeignTypeInfo $foreignTypeInfo
   */
  public function setForeignTypeInfo(ForeignTypeInfo $foreignTypeInfo)
  {
    $this->foreignTypeInfo = $foreignTypeInfo;
  }
  /**
   * @return ForeignTypeInfo
   */
  public function getForeignTypeInfo()
  {
    return $this->foreignTypeInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TableSchema::class, 'Google_Service_Bigquery_TableSchema');
