<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BinaryAuthorization;

class VerificationRule extends \Google\Collection
{
  /**
   * Should never happen.
   */
  public const TRUSTED_BUILDER_BUILDER_UNSPECIFIED = 'BUILDER_UNSPECIFIED';
  /**
   * The whole Google Cloud Build (GCB) builder group, including all GCB builder
   * types.
   */
  public const TRUSTED_BUILDER_GOOGLE_CLOUD_BUILD = 'GOOGLE_CLOUD_BUILD';
  protected $collection_key = 'trustedSourceRepoPatterns';
  protected $attestationSourceType = AttestationSource::class;
  protected $attestationSourceDataType = '';
  /**
   * If true, require the image to be built from a top-level configuration.
   * `trusted_source_repo_patterns` specifies the repositories containing this
   * configuration.
   *
   * @var bool
   */
  public $configBasedBuildRequired;
  /**
   * Optional. A CEL expression for specifying custom constraints on the
   * provenance payload. This can be used when users want to specify
   * expectations on provenance fields that are not covered by the general
   * check. For example, users can use this field to require that certain
   * parameters should never be used during the build process.
   *
   * @var string
   */
  public $customConstraints;
  /**
   * Each verification rule is used for evaluation against provenances generated
   * by a specific builder (group). For some of the builders, such as the Google
   * Cloud Build, users don't need to explicitly specify their roots of trust in
   * the policy since the evaluation service can automatically fetch them based
   * on the builder (group).
   *
   * @var string
   */
  public $trustedBuilder;
  /**
   * List of trusted source code repository URL patterns. These patterns match
   * the full repository URL without its scheme (e.g. `https://`). The patterns
   * must not include schemes. For example, the pattern
   * `source.cloud.google.com/my-project/my-repo-name` matches the following
   * URLs: - `source.cloud.google.com/my-project/my-repo-name` -
   * `git+ssh://source.cloud.google.com/my-project/my-repo-name` -
   * `https://source.cloud.google.com/my-project/my-repo-name` A pattern matches
   * a URL either exactly or with `*` wildcards. `*` can be used in only two
   * ways: 1. trailing `*` after hosturi/ to match varying endings; 2. trailing
   * `**` after hosturi/ to match `/` as well. `*` and `**` can only be used as
   * wildcards and can only occur at the end of the pattern after a `/`. (So
   * it's not possible to match a URL that contains literal `*`.) For example: -
   * `github.com/my-project/my-repo` is valid to match a single repo -
   * `github.com/my-project` will match all direct repos in `my-project` -
   * `github.com*` matches all repos in GitHub
   *
   * @var string[]
   */
  public $trustedSourceRepoPatterns;

  /**
   * Specifies where to fetch the provenances attestations generated by the
   * builder (group).
   *
   * @param AttestationSource $attestationSource
   */
  public function setAttestationSource(AttestationSource $attestationSource)
  {
    $this->attestationSource = $attestationSource;
  }
  /**
   * @return AttestationSource
   */
  public function getAttestationSource()
  {
    return $this->attestationSource;
  }
  /**
   * If true, require the image to be built from a top-level configuration.
   * `trusted_source_repo_patterns` specifies the repositories containing this
   * configuration.
   *
   * @param bool $configBasedBuildRequired
   */
  public function setConfigBasedBuildRequired($configBasedBuildRequired)
  {
    $this->configBasedBuildRequired = $configBasedBuildRequired;
  }
  /**
   * @return bool
   */
  public function getConfigBasedBuildRequired()
  {
    return $this->configBasedBuildRequired;
  }
  /**
   * Optional. A CEL expression for specifying custom constraints on the
   * provenance payload. This can be used when users want to specify
   * expectations on provenance fields that are not covered by the general
   * check. For example, users can use this field to require that certain
   * parameters should never be used during the build process.
   *
   * @param string $customConstraints
   */
  public function setCustomConstraints($customConstraints)
  {
    $this->customConstraints = $customConstraints;
  }
  /**
   * @return string
   */
  public function getCustomConstraints()
  {
    return $this->customConstraints;
  }
  /**
   * Each verification rule is used for evaluation against provenances generated
   * by a specific builder (group). For some of the builders, such as the Google
   * Cloud Build, users don't need to explicitly specify their roots of trust in
   * the policy since the evaluation service can automatically fetch them based
   * on the builder (group).
   *
   * Accepted values: BUILDER_UNSPECIFIED, GOOGLE_CLOUD_BUILD
   *
   * @param self::TRUSTED_BUILDER_* $trustedBuilder
   */
  public function setTrustedBuilder($trustedBuilder)
  {
    $this->trustedBuilder = $trustedBuilder;
  }
  /**
   * @return self::TRUSTED_BUILDER_*
   */
  public function getTrustedBuilder()
  {
    return $this->trustedBuilder;
  }
  /**
   * List of trusted source code repository URL patterns. These patterns match
   * the full repository URL without its scheme (e.g. `https://`). The patterns
   * must not include schemes. For example, the pattern
   * `source.cloud.google.com/my-project/my-repo-name` matches the following
   * URLs: - `source.cloud.google.com/my-project/my-repo-name` -
   * `git+ssh://source.cloud.google.com/my-project/my-repo-name` -
   * `https://source.cloud.google.com/my-project/my-repo-name` A pattern matches
   * a URL either exactly or with `*` wildcards. `*` can be used in only two
   * ways: 1. trailing `*` after hosturi/ to match varying endings; 2. trailing
   * `**` after hosturi/ to match `/` as well. `*` and `**` can only be used as
   * wildcards and can only occur at the end of the pattern after a `/`. (So
   * it's not possible to match a URL that contains literal `*`.) For example: -
   * `github.com/my-project/my-repo` is valid to match a single repo -
   * `github.com/my-project` will match all direct repos in `my-project` -
   * `github.com*` matches all repos in GitHub
   *
   * @param string[] $trustedSourceRepoPatterns
   */
  public function setTrustedSourceRepoPatterns($trustedSourceRepoPatterns)
  {
    $this->trustedSourceRepoPatterns = $trustedSourceRepoPatterns;
  }
  /**
   * @return string[]
   */
  public function getTrustedSourceRepoPatterns()
  {
    return $this->trustedSourceRepoPatterns;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VerificationRule::class, 'Google_Service_BinaryAuthorization_VerificationRule');
