<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CCAIPlatform;

class UnwantedEventInterval extends \Google\Model
{
  /**
   * Required. Duration of the event.
   *
   * @var int
   */
  public $durationMinutes;
  protected $startTimeType = DateTime::class;
  protected $startTimeDataType = '';

  /**
   * Required. Duration of the event.
   *
   * @param int $durationMinutes
   */
  public function setDurationMinutes($durationMinutes)
  {
    $this->durationMinutes = $durationMinutes;
  }
  /**
   * @return int
   */
  public function getDurationMinutes()
  {
    return $this->durationMinutes;
  }
  /**
   * Required. Start time of the event.
   *
   * @param DateTime $startTime
   */
  public function setStartTime(DateTime $startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return DateTime
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UnwantedEventInterval::class, 'Google_Service_CCAIPlatform_UnwantedEventInterval');
