<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudRetail;

class GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel extends \Google\Collection
{
  protected $collection_key = 'candidates';
  protected $candidatesType = GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate::class;
  protected $candidatesDataType = 'array';
  protected $defaultCandidateType = GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate::class;
  protected $defaultCandidateDataType = '';
  /**
   * Optional. The name to display for the panel.
   *
   * @var string
   */
  public $displayName;

  /**
   * Required. The candidates to consider on the panel.
   *
   * @param GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate[] $candidates
   */
  public function setCandidates($candidates)
  {
    $this->candidates = $candidates;
  }
  /**
   * @return GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate[]
   */
  public function getCandidates()
  {
    return $this->candidates;
  }
  /**
   * Required. The default candidate. If the model fails at serving time, we
   * fall back to the default.
   *
   * @param GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate $defaultCandidate
   */
  public function setDefaultCandidate(GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate $defaultCandidate)
  {
    $this->defaultCandidate = $defaultCandidate;
  }
  /**
   * @return GoogleCloudRetailV2alphaModelPageOptimizationConfigCandidate
   */
  public function getDefaultCandidate()
  {
    return $this->defaultCandidate;
  }
  /**
   * Optional. The name to display for the panel.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel::class, 'Google_Service_CloudRetail_GoogleCloudRetailV2alphaModelPageOptimizationConfigPanel');
