<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Image extends \Google\Collection
{
  /**
   * Default value indicating Architecture is not set.
   */
  public const ARCHITECTURE_ARCHITECTURE_UNSPECIFIED = 'ARCHITECTURE_UNSPECIFIED';
  /**
   * Machines with architecture ARM64
   */
  public const ARCHITECTURE_ARM64 = 'ARM64';
  /**
   * Machines with architecture X86_64
   */
  public const ARCHITECTURE_X86_64 = 'X86_64';
  public const SOURCE_TYPE_RAW = 'RAW';
  /**
   * Image is deleting.
   */
  public const STATUS_DELETING = 'DELETING';
  /**
   * Image creation failed due to an error.
   */
  public const STATUS_FAILED = 'FAILED';
  /**
   * Image hasn't been created as yet.
   */
  public const STATUS_PENDING = 'PENDING';
  /**
   * Image has been successfully created.
   */
  public const STATUS_READY = 'READY';
  protected $collection_key = 'storageLocations';
  /**
   * The architecture of the image. Valid values are ARM64 or X86_64.
   *
   * @var string
   */
  public $architecture;
  /**
   * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
   *
   * @var string
   */
  public $archiveSizeBytes;
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  protected $deprecatedType = DeprecationStatus::class;
  protected $deprecatedDataType = '';
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * Size of the image when restored onto a persistent disk (in GB).
   *
   * @var string
   */
  public $diskSizeGb;
  /**
   * Output only. Whether this image is created from a confidential compute mode
   * disk. [Output Only]: This field is not set by user, but from source disk.
   *
   * @var bool
   */
  public $enableConfidentialCompute;
  /**
   * The name of the image family to which this image belongs. The image family
   * name can be from a publicly managed image family provided by Compute
   * Engine, or from a custom image family you create. For example,centos-
   * stream-9 is a publicly available image family. For more information, see
   * Image family best practices.
   *
   * When creating disks, you can specify an image family instead of a specific
   * image name. The image family always returns its latest image that is not
   * deprecated. The name of the image family must comply with RFC1035.
   *
   * @var string
   */
  public $family;
  protected $guestOsFeaturesType = GuestOsFeature::class;
  protected $guestOsFeaturesDataType = 'array';
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @var string
   */
  public $id;
  protected $imageEncryptionKeyType = CustomerEncryptionKey::class;
  protected $imageEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] Type of the resource. Always compute#image for
   * images.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this image, which is
   * essentially a hash of the labels used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve an image.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this image. These can be later modified by the setLabels
   * method.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Integer license codes indicating which licenses are attached to this image.
   *
   * @var string[]
   */
  public $licenseCodes;
  /**
   * Any applicable license URI.
   *
   * @var string[]
   */
  public $licenses;
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  protected $paramsType = ImageParams::class;
  protected $paramsDataType = '';
  protected $rawDiskType = ImageRawDisk::class;
  protected $rawDiskDataType = '';
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * Output only. [Output Only] Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  /**
   * Output only. [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  protected $shieldedInstanceInitialStateType = InitialStateConfig::class;
  protected $shieldedInstanceInitialStateDataType = '';
  /**
   * URL of the source disk used to create this image. For example, the
   * following are valid values:        - https://www.googleapis.com/compute/v1/
   * projects/project/zones/zone/disks/disk     -
   * projects/project/zones/zone/disks/disk     - zones/zone/disks/disk
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @var string
   */
  public $sourceDisk;
  protected $sourceDiskEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceDiskEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] The ID value of the disk used to create this
   * image. This value may be used to determine whether the image was taken from
   * the current or a previous instance of a given disk name.
   *
   * @var string
   */
  public $sourceDiskId;
  /**
   * URL of the source image used to create this image. The following are valid
   * formats for the URL:        -
   * https://www.googleapis.com/compute/v1/projects/project_id/global/
   * images/image_name    - projects/project_id/global/images/image_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @var string
   */
  public $sourceImage;
  protected $sourceImageEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceImageEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] The ID value of the image used to create this
   * image. This value may be used to determine whether the image was taken from
   * the current or a previous instance of a given image name.
   *
   * @var string
   */
  public $sourceImageId;
  /**
   * URL of the source snapshot used to create this image. The following are
   * valid formats for the URL:        -
   * https://www.googleapis.com/compute/v1/projects/project_id/global/
   * snapshots/snapshot_name    -
   * projects/project_id/global/snapshots/snapshot_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @var string
   */
  public $sourceSnapshot;
  protected $sourceSnapshotEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceSnapshotEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] The ID value of the snapshot used to create this
   * image. This value may be used to determine whether the snapshot was taken
   * from the current or a previous instance of a given snapshot name.
   *
   * @var string
   */
  public $sourceSnapshotId;
  /**
   * The type of the image used to create this disk. The default and only valid
   * value is RAW.
   *
   * @var string
   */
  public $sourceType;
  /**
   * Output only. [Output Only] The status of the image. An image can be used to
   * create other resources, such as instances, only after the image has been
   * successfully created and the status is set to READY. Possible values are
   * FAILED, PENDING, orREADY.
   *
   * @var string
   */
  public $status;
  /**
   * Cloud Storage bucket storage location of the image (regional or multi-
   * regional).
   *
   * @var string[]
   */
  public $storageLocations;

  /**
   * The architecture of the image. Valid values are ARM64 or X86_64.
   *
   * Accepted values: ARCHITECTURE_UNSPECIFIED, ARM64, X86_64
   *
   * @param self::ARCHITECTURE_* $architecture
   */
  public function setArchitecture($architecture)
  {
    $this->architecture = $architecture;
  }
  /**
   * @return self::ARCHITECTURE_*
   */
  public function getArchitecture()
  {
    return $this->architecture;
  }
  /**
   * Size of the image tar.gz archive stored in Google Cloud Storage (in bytes).
   *
   * @param string $archiveSizeBytes
   */
  public function setArchiveSizeBytes($archiveSizeBytes)
  {
    $this->archiveSizeBytes = $archiveSizeBytes;
  }
  /**
   * @return string
   */
  public function getArchiveSizeBytes()
  {
    return $this->archiveSizeBytes;
  }
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * Output only. The deprecation status associated with this image.
   *
   * @param DeprecationStatus $deprecated
   */
  public function setDeprecated(DeprecationStatus $deprecated)
  {
    $this->deprecated = $deprecated;
  }
  /**
   * @return DeprecationStatus
   */
  public function getDeprecated()
  {
    return $this->deprecated;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Size of the image when restored onto a persistent disk (in GB).
   *
   * @param string $diskSizeGb
   */
  public function setDiskSizeGb($diskSizeGb)
  {
    $this->diskSizeGb = $diskSizeGb;
  }
  /**
   * @return string
   */
  public function getDiskSizeGb()
  {
    return $this->diskSizeGb;
  }
  /**
   * Output only. Whether this image is created from a confidential compute mode
   * disk. [Output Only]: This field is not set by user, but from source disk.
   *
   * @param bool $enableConfidentialCompute
   */
  public function setEnableConfidentialCompute($enableConfidentialCompute)
  {
    $this->enableConfidentialCompute = $enableConfidentialCompute;
  }
  /**
   * @return bool
   */
  public function getEnableConfidentialCompute()
  {
    return $this->enableConfidentialCompute;
  }
  /**
   * The name of the image family to which this image belongs. The image family
   * name can be from a publicly managed image family provided by Compute
   * Engine, or from a custom image family you create. For example,centos-
   * stream-9 is a publicly available image family. For more information, see
   * Image family best practices.
   *
   * When creating disks, you can specify an image family instead of a specific
   * image name. The image family always returns its latest image that is not
   * deprecated. The name of the image family must comply with RFC1035.
   *
   * @param string $family
   */
  public function setFamily($family)
  {
    $this->family = $family;
  }
  /**
   * @return string
   */
  public function getFamily()
  {
    return $this->family;
  }
  /**
   * A list of features to enable on the guest operating system. Applicable only
   * for bootable images. To see a list of available options, see
   * theguestOSfeatures[].type parameter.
   *
   * @param GuestOsFeature[] $guestOsFeatures
   */
  public function setGuestOsFeatures($guestOsFeatures)
  {
    $this->guestOsFeatures = $guestOsFeatures;
  }
  /**
   * @return GuestOsFeature[]
   */
  public function getGuestOsFeatures()
  {
    return $this->guestOsFeatures;
  }
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Encrypts the image using acustomer-supplied encryption key.
   *
   * After you encrypt an image with a customer-supplied key, you must provide
   * the same key if you use the image later (e.g. to create a disk from the
   * image).
   *
   * Customer-supplied encryption keys do not protect access to metadata of the
   * disk.
   *
   * If you do not provide an encryption key when creating the image, then the
   * disk will be encrypted using an automatically generated key and you do not
   * need to provide a key to use the image later.
   *
   * @param CustomerEncryptionKey $imageEncryptionKey
   */
  public function setImageEncryptionKey(CustomerEncryptionKey $imageEncryptionKey)
  {
    $this->imageEncryptionKey = $imageEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getImageEncryptionKey()
  {
    return $this->imageEncryptionKey;
  }
  /**
   * Output only. [Output Only] Type of the resource. Always compute#image for
   * images.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this image, which is
   * essentially a hash of the labels used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve an image.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this image. These can be later modified by the setLabels
   * method.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Integer license codes indicating which licenses are attached to this image.
   *
   * @param string[] $licenseCodes
   */
  public function setLicenseCodes($licenseCodes)
  {
    $this->licenseCodes = $licenseCodes;
  }
  /**
   * @return string[]
   */
  public function getLicenseCodes()
  {
    return $this->licenseCodes;
  }
  /**
   * Any applicable license URI.
   *
   * @param string[] $licenses
   */
  public function setLicenses($licenses)
  {
    $this->licenses = $licenses;
  }
  /**
   * @return string[]
   */
  public function getLicenses()
  {
    return $this->licenses;
  }
  /**
   * Name of the resource; provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Input only. [Input Only] Additional params passed with the request, but not
   * persisted as part of resource payload.
   *
   * @param ImageParams $params
   */
  public function setParams(ImageParams $params)
  {
    $this->params = $params;
  }
  /**
   * @return ImageParams
   */
  public function getParams()
  {
    return $this->params;
  }
  /**
   * The parameters of the raw disk image.
   *
   * @param ImageRawDisk $rawDisk
   */
  public function setRawDisk(ImageRawDisk $rawDisk)
  {
    $this->rawDisk = $rawDisk;
  }
  /**
   * @return ImageRawDisk
   */
  public function getRawDisk()
  {
    return $this->rawDisk;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * Output only. [Output Only] Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * Output only. [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Set the secure boot keys of shielded instance.
   *
   * @param InitialStateConfig $shieldedInstanceInitialState
   */
  public function setShieldedInstanceInitialState(InitialStateConfig $shieldedInstanceInitialState)
  {
    $this->shieldedInstanceInitialState = $shieldedInstanceInitialState;
  }
  /**
   * @return InitialStateConfig
   */
  public function getShieldedInstanceInitialState()
  {
    return $this->shieldedInstanceInitialState;
  }
  /**
   * URL of the source disk used to create this image. For example, the
   * following are valid values:        - https://www.googleapis.com/compute/v1/
   * projects/project/zones/zone/disks/disk     -
   * projects/project/zones/zone/disks/disk     - zones/zone/disks/disk
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @param string $sourceDisk
   */
  public function setSourceDisk($sourceDisk)
  {
    $this->sourceDisk = $sourceDisk;
  }
  /**
   * @return string
   */
  public function getSourceDisk()
  {
    return $this->sourceDisk;
  }
  /**
   * Thecustomer-supplied encryption key of the source disk. Required if the
   * source disk is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceDiskEncryptionKey
   */
  public function setSourceDiskEncryptionKey(CustomerEncryptionKey $sourceDiskEncryptionKey)
  {
    $this->sourceDiskEncryptionKey = $sourceDiskEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceDiskEncryptionKey()
  {
    return $this->sourceDiskEncryptionKey;
  }
  /**
   * Output only. [Output Only] The ID value of the disk used to create this
   * image. This value may be used to determine whether the image was taken from
   * the current or a previous instance of a given disk name.
   *
   * @param string $sourceDiskId
   */
  public function setSourceDiskId($sourceDiskId)
  {
    $this->sourceDiskId = $sourceDiskId;
  }
  /**
   * @return string
   */
  public function getSourceDiskId()
  {
    return $this->sourceDiskId;
  }
  /**
   * URL of the source image used to create this image. The following are valid
   * formats for the URL:        -
   * https://www.googleapis.com/compute/v1/projects/project_id/global/
   * images/image_name    - projects/project_id/global/images/image_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @param string $sourceImage
   */
  public function setSourceImage($sourceImage)
  {
    $this->sourceImage = $sourceImage;
  }
  /**
   * @return string
   */
  public function getSourceImage()
  {
    return $this->sourceImage;
  }
  /**
   * The customer-supplied encryption key of the source image. Required if the
   * source image is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceImageEncryptionKey
   */
  public function setSourceImageEncryptionKey(CustomerEncryptionKey $sourceImageEncryptionKey)
  {
    $this->sourceImageEncryptionKey = $sourceImageEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceImageEncryptionKey()
  {
    return $this->sourceImageEncryptionKey;
  }
  /**
   * Output only. [Output Only] The ID value of the image used to create this
   * image. This value may be used to determine whether the image was taken from
   * the current or a previous instance of a given image name.
   *
   * @param string $sourceImageId
   */
  public function setSourceImageId($sourceImageId)
  {
    $this->sourceImageId = $sourceImageId;
  }
  /**
   * @return string
   */
  public function getSourceImageId()
  {
    return $this->sourceImageId;
  }
  /**
   * URL of the source snapshot used to create this image. The following are
   * valid formats for the URL:        -
   * https://www.googleapis.com/compute/v1/projects/project_id/global/
   * snapshots/snapshot_name    -
   * projects/project_id/global/snapshots/snapshot_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @param string $sourceSnapshot
   */
  public function setSourceSnapshot($sourceSnapshot)
  {
    $this->sourceSnapshot = $sourceSnapshot;
  }
  /**
   * @return string
   */
  public function getSourceSnapshot()
  {
    return $this->sourceSnapshot;
  }
  /**
   * The customer-supplied encryption key of the source snapshot. Required if
   * the source snapshot is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceSnapshotEncryptionKey
   */
  public function setSourceSnapshotEncryptionKey(CustomerEncryptionKey $sourceSnapshotEncryptionKey)
  {
    $this->sourceSnapshotEncryptionKey = $sourceSnapshotEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceSnapshotEncryptionKey()
  {
    return $this->sourceSnapshotEncryptionKey;
  }
  /**
   * Output only. [Output Only] The ID value of the snapshot used to create this
   * image. This value may be used to determine whether the snapshot was taken
   * from the current or a previous instance of a given snapshot name.
   *
   * @param string $sourceSnapshotId
   */
  public function setSourceSnapshotId($sourceSnapshotId)
  {
    $this->sourceSnapshotId = $sourceSnapshotId;
  }
  /**
   * @return string
   */
  public function getSourceSnapshotId()
  {
    return $this->sourceSnapshotId;
  }
  /**
   * The type of the image used to create this disk. The default and only valid
   * value is RAW.
   *
   * Accepted values: RAW
   *
   * @param self::SOURCE_TYPE_* $sourceType
   */
  public function setSourceType($sourceType)
  {
    $this->sourceType = $sourceType;
  }
  /**
   * @return self::SOURCE_TYPE_*
   */
  public function getSourceType()
  {
    return $this->sourceType;
  }
  /**
   * Output only. [Output Only] The status of the image. An image can be used to
   * create other resources, such as instances, only after the image has been
   * successfully created and the status is set to READY. Possible values are
   * FAILED, PENDING, orREADY.
   *
   * Accepted values: DELETING, FAILED, PENDING, READY
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * Cloud Storage bucket storage location of the image (regional or multi-
   * regional).
   *
   * @param string[] $storageLocations
   */
  public function setStorageLocations($storageLocations)
  {
    $this->storageLocations = $storageLocations;
  }
  /**
   * @return string[]
   */
  public function getStorageLocations()
  {
    return $this->storageLocations;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Image::class, 'Google_Service_Compute_Image');
