<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Tags extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * Specifies a fingerprint for this request, which is essentially a hash of
   * the tags' contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update tags. You must always provide an up-to-date fingerprint
   * hash in order to update or change tags.
   *
   * To see the latest fingerprint, make get() request to the instance.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * An array of tags. Each tag must be 1-63 characters long, and comply with
   * RFC1035.
   *
   * @var string[]
   */
  public $items;

  /**
   * Specifies a fingerprint for this request, which is essentially a hash of
   * the tags' contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update tags. You must always provide an up-to-date fingerprint
   * hash in order to update or change tags.
   *
   * To see the latest fingerprint, make get() request to the instance.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * An array of tags. Each tag must be 1-63 characters long, and comply with
   * RFC1035.
   *
   * @param string[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return string[]
   */
  public function getItems()
  {
    return $this->items;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Tags::class, 'Google_Service_Compute_Tags');
