<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class WafExpressionSet extends \Google\Collection
{
  protected $collection_key = 'expressions';
  /**
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic
   * suffix like "stable" is particularly useful if a policy likes to avail
   * newer set of expressions without having to change the policy. A given alias
   * name can't be used for more than one entity set.
   *
   * @var string[]
   */
  public $aliases;
  protected $expressionsType = WafExpressionSetExpression::class;
  protected $expressionsDataType = 'array';
  /**
   * Google specified expression set ID. The format should be: - E.g.
   * XSS-20170329 required
   *
   * @var string
   */
  public $id;

  /**
   * A list of alternate IDs. The format should be: - E.g. XSS-stable Generic
   * suffix like "stable" is particularly useful if a policy likes to avail
   * newer set of expressions without having to change the policy. A given alias
   * name can't be used for more than one entity set.
   *
   * @param string[] $aliases
   */
  public function setAliases($aliases)
  {
    $this->aliases = $aliases;
  }
  /**
   * @return string[]
   */
  public function getAliases()
  {
    return $this->aliases;
  }
  /**
   * List of available expressions.
   *
   * @param WafExpressionSetExpression[] $expressions
   */
  public function setExpressions($expressions)
  {
    $this->expressions = $expressions;
  }
  /**
   * @return WafExpressionSetExpression[]
   */
  public function getExpressions()
  {
    return $this->expressions;
  }
  /**
   * Google specified expression set ID. The format should be: - E.g.
   * XSS-20170329 required
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WafExpressionSet::class, 'Google_Service_Compute_WafExpressionSet');
