<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Connectors;

class SloEligibility extends \Google\Model
{
  /**
   * Whether an instance is eligible or ineligible.
   *
   * @var bool
   */
  public $eligible;
  /**
   * User-defined reason for the current value of instance eligibility. Usually,
   * this can be directly mapped to the internal state. An empty reason is
   * allowed.
   *
   * @var string
   */
  public $reason;

  /**
   * Whether an instance is eligible or ineligible.
   *
   * @param bool $eligible
   */
  public function setEligible($eligible)
  {
    $this->eligible = $eligible;
  }
  /**
   * @return bool
   */
  public function getEligible()
  {
    return $this->eligible;
  }
  /**
   * User-defined reason for the current value of instance eligibility. Usually,
   * this can be directly mapped to the internal state. An empty reason is
   * allowed.
   *
   * @param string $reason
   */
  public function setReason($reason)
  {
    $this->reason = $reason;
  }
  /**
   * @return string
   */
  public function getReason()
  {
    return $this->reason;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SloEligibility::class, 'Google_Service_Connectors_SloEligibility');
