<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GoogleCloudContentwarehouseV1DataValidationAction extends \Google\Model
{
  /**
   * Map of (K, V) -> (field, string condition to be evaluated on the field)
   * E.g., ("age", "age > 18 && age < 60") entry triggers validation of field
   * age with the given condition. Map entries will be ANDed during validation.
   *
   * @var string[]
   */
  public $conditions;

  /**
   * Map of (K, V) -> (field, string condition to be evaluated on the field)
   * E.g., ("age", "age > 18 && age < 60") entry triggers validation of field
   * age with the given condition. Map entries will be ANDed during validation.
   *
   * @param string[] $conditions
   */
  public function setConditions($conditions)
  {
    $this->conditions = $conditions;
  }
  /**
   * @return string[]
   */
  public function getConditions()
  {
    return $this->conditions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContentwarehouseV1DataValidationAction::class, 'Google_Service_Contentwarehouse_GoogleCloudContentwarehouseV1DataValidationAction');
