<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowV2beta1IntentMessageListSelect extends \Google\Collection
{
  protected $collection_key = 'items';
  protected $itemsType = GoogleCloudDialogflowV2beta1IntentMessageListSelectItem::class;
  protected $itemsDataType = 'array';
  /**
   * Optional. Subtitle of the list.
   *
   * @var string
   */
  public $subtitle;
  /**
   * Optional. The overall title of the list.
   *
   * @var string
   */
  public $title;

  /**
   * Required. List items.
   *
   * @param GoogleCloudDialogflowV2beta1IntentMessageListSelectItem[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return GoogleCloudDialogflowV2beta1IntentMessageListSelectItem[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * Optional. Subtitle of the list.
   *
   * @param string $subtitle
   */
  public function setSubtitle($subtitle)
  {
    $this->subtitle = $subtitle;
  }
  /**
   * @return string
   */
  public function getSubtitle()
  {
    return $this->subtitle;
  }
  /**
   * Optional. The overall title of the list.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowV2beta1IntentMessageListSelect::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowV2beta1IntentMessageListSelect');
