<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Directory;

class UserSshPublicKey extends \Google\Model
{
  /**
   * An expiration time in microseconds since epoch.
   *
   * @var string
   */
  public $expirationTimeUsec;
  /**
   * A SHA-256 fingerprint of the SSH public key. (Read-only)
   *
   * @var string
   */
  public $fingerprint;
  /**
   * An SSH public key.
   *
   * @var string
   */
  public $key;

  /**
   * An expiration time in microseconds since epoch.
   *
   * @param string $expirationTimeUsec
   */
  public function setExpirationTimeUsec($expirationTimeUsec)
  {
    $this->expirationTimeUsec = $expirationTimeUsec;
  }
  /**
   * @return string
   */
  public function getExpirationTimeUsec()
  {
    return $this->expirationTimeUsec;
  }
  /**
   * A SHA-256 fingerprint of the SSH public key. (Read-only)
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * An SSH public key.
   *
   * @param string $key
   */
  public function setKey($key)
  {
    $this->key = $key;
  }
  /**
   * @return string
   */
  public function getKey()
  {
    return $this->key;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UserSshPublicKey::class, 'Google_Service_Directory_UserSshPublicKey');
