<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\OnDemandScanning;

class GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource extends \Google\Model
{
  /**
   * @var string[]
   */
  public $digest;
  /**
   * @var string
   */
  public $entryPoint;
  /**
   * @var string
   */
  public $uri;

  /**
   * @param string[] $digest
   */
  public function setDigest($digest)
  {
    $this->digest = $digest;
  }
  /**
   * @return string[]
   */
  public function getDigest()
  {
    return $this->digest;
  }
  /**
   * @param string $entryPoint
   */
  public function setEntryPoint($entryPoint)
  {
    $this->entryPoint = $entryPoint;
  }
  /**
   * @return string
   */
  public function getEntryPoint()
  {
    return $this->entryPoint;
  }
  /**
   * @param string $uri
   */
  public function setUri($uri)
  {
    $this->uri = $uri;
  }
  /**
   * @return string
   */
  public function getUri()
  {
    return $this->uri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource::class, 'Google_Service_OnDemandScanning_GrafeasV1SlsaProvenanceZeroTwoSlsaConfigSource');
