<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Playdeveloperreporting;

class GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse extends \Google\Collection
{
  protected $collection_key = 'anomalies';
  protected $anomaliesType = GooglePlayDeveloperReportingV1beta1Anomaly::class;
  protected $anomaliesDataType = 'array';
  /**
   * Continuation token to fetch the next page of data.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * Anomalies that were found.
   *
   * @param GooglePlayDeveloperReportingV1beta1Anomaly[] $anomalies
   */
  public function setAnomalies($anomalies)
  {
    $this->anomalies = $anomalies;
  }
  /**
   * @return GooglePlayDeveloperReportingV1beta1Anomaly[]
   */
  public function getAnomalies()
  {
    return $this->anomalies;
  }
  /**
   * Continuation token to fetch the next page of data.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse::class, 'Google_Service_Playdeveloperreporting_GooglePlayDeveloperReportingV1beta1ListAnomaliesResponse');
