<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Transcoder;

class Overlay extends \Google\Collection
{
  protected $collection_key = 'animations';
  protected $animationsType = Animation::class;
  protected $animationsDataType = 'array';
  protected $imageType = Image::class;
  protected $imageDataType = '';

  /**
   * List of animations. The list should be chronological, without any time
   * overlap.
   *
   * @param Animation[] $animations
   */
  public function setAnimations($animations)
  {
    $this->animations = $animations;
  }
  /**
   * @return Animation[]
   */
  public function getAnimations()
  {
    return $this->animations;
  }
  /**
   * Image overlay.
   *
   * @param Image $image
   */
  public function setImage(Image $image)
  {
    $this->image = $image;
  }
  /**
   * @return Image
   */
  public function getImage()
  {
    return $this->image;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Overlay::class, 'Google_Service_Transcoder_Overlay');
